import torch.optim as optim
import torch
import torch.nn as nn
import torch.nn.functional as F
from torch.utils.data import DataLoader
import torchvision

from torchvision import datasets
from torchvision import transforms

generator = nn.Sequential(
            # Dense layer to project and reshape the latent space
            nn.Linear(100, 2 * 2 * 512, bias=False),
            nn.BatchNorm1d(2 * 2 * 512),
            nn.LeakyReLU(0.2, inplace=True),

            # Reshape to start convolutional layers
            nn.Unflatten(1, (512, 2, 2)),  # Reshapes (batch_size, 2048) -> (batch_size, 512, 2, 2)
            
            # First ConvTranspose2d Layer: Output size (4x4x256)
            nn.ConvTranspose2d(512, 256, kernel_size=5, stride=2, padding=2, output_padding=1, bias=False),
            nn.BatchNorm2d(256),
            nn.LeakyReLU(0.2, inplace=True),

            # Second ConvTranspose2d Layer: Output size (8x8x128)
            nn.ConvTranspose2d(256, 128, kernel_size=5, stride=2, padding=2, output_padding=1, bias=False),
            nn.BatchNorm2d(128),
            nn.LeakyReLU(0.2, inplace=True),

            # Third ConvTranspose2d Layer: Output size (16x16x64)
            nn.ConvTranspose2d(128, 64, kernel_size=5, stride=2, padding=2, output_padding=1, bias=False),
            nn.BatchNorm2d(64),
            nn.LeakyReLU(0.2, inplace=True),

            # Final ConvTranspose2d Layer: Output size (32x32x3)
            nn.ConvTranspose2d(64, 3, kernel_size=5, stride=2, padding=2, output_padding=1, bias=False),
            nn.Tanh()  # Output is constrained between -1 and 1
        )

discriminator = nn.Sequential(
            # First Conv layer: Output size (16x16x64)
            nn.Conv2d(in_channels=3, out_channels=64, kernel_size=5, stride=2, padding=2),
            nn.LeakyReLU(0.2, inplace=True),
            nn.Dropout(0.3),

            # Second Conv layer: Output size (8x8x128)
            nn.Conv2d(64, 128, kernel_size=5, stride=2, padding=2),
            nn.LeakyReLU(0.2, inplace=True),
            nn.Dropout(0.3),
            
            # Third Conv layer: Output size (4x4x256)
            nn.Conv2d(128, 256, kernel_size=5, stride=2, padding=2),
            nn.LeakyReLU(0.2, inplace=True),
            nn.Dropout(0.3),

            # Fourth Conv layer: Output size (2x2x512)
            nn.Conv2d(256, 512, kernel_size=5, stride=2, padding=2),
            nn.LeakyReLU(0.2, inplace=True),
            nn.Dropout(0.3),
            
            # Flatten the feature maps into a vector
            nn.Flatten(),
            
            # Fully connected layer for binary classification (real/fake)
            nn.Linear(2 * 2 * 512, 1),
            nn.Sigmoid()  # Output a probability between 0 and 1
        )


